//  FolderDialog.cs
//  Copyright (C) 2002 Mike Krueger
//  Copyright (C) 2002 Christoph Wille
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//  Revisited by Alain VIZZINI to be a stand alone component working easily with the minimum
//  amount of libs to include.
//  NB : This will *NOT WORK* unless you "Add Reference .. ->.NET -> System.Design.dll" !!!
//  It's weirdow as everything else seems handled, but hey ! That's life ...
//  Mail : alainvizzini@altern.org  Web : http://www.essisharp.ht.st

using System.Windows.Forms.Design;
using System.Windows.Forms;
using System;

//namespace SharpDevelop.Gui.Dialogs {
	
	/// <summary>
	/// This class helps to display the directory structure in the folder
	/// As the FolderBrowser is inaccessible we have to inherit from the
	/// FileNameBroswer and then call the method
	/// </summary>
public class FolderDialog : FolderNameEditor{
	private String path;
	public string Path {
		get {
			return path;
		}
	}
		
	public FolderDialog(){}
		
	public DialogResult DisplayDialog(){
		return DisplayDialog("Choisissez un rpertoire :");
	}

	public DialogResult DisplayDialog(String description){	
		/*
		 * Original SharpDevelop Code
		 * 
		HelperServices.ExecuteDirect ed = new HelperServices.ExecuteDirect();
		
		int hwnd = 0;
		bool gotPath = ed.BrowseForFolder(description, hwnd, ref path);
		
		return gotPath ? DialogResult.OK : DialogResult.Cancel;
		*/
		FolderBrowser f = new FolderBrowser();
		f.Description = description;
		f.StartLocation = FolderBrowserFolder.Desktop;
		DialogResult d = f.ShowDialog();
		path = f.DirectoryPath;
		return d;
	}
}
//}
