using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Windows.Forms.Design;
using System.Data;

using System.Net;
using System.IO;
using System.Text.RegularExpressions; //RegEx

using System.Threading;


namespace WebPicsDownloader
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		/// <summary>
		/// pour reconnaitre un chevron "<img ... >"
		/// </summary>
		private static Regex rImg = new Regex (@"<(i|I)(m|M)(g|G)[^>]*>");
		/// <summary>
		/// pour reconnaitre la membre 'src="..."' d'un chevron image
		/// </summary>
		private static Regex rSrcAttr = new Regex ("(s|S)(r|R)(c|C)=\"(?<imgUrl>[^\"]+)\"");
		/// <summary>
		/// Pour reconnaitre un chevron '<a href="...">'
		/// </summary>
		private static Regex rAHref = new Regex ("<(a|A)[^>]*(h|H)(r|R)(e|E)(f|F)=\"(?<destUrl>[^\"]+)\"[^>]*>");
		
		/// <summary>
		/// La fenetre de vue HTML par composante IE
		/// </summary>
		private frmIEView ieView = null;
		
		private System.Windows.Forms.Button btnDownload;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.CheckBox ckbLinked;
		private System.Windows.Forms.CheckBox ckbOnPage;
		private System.Windows.Forms.Button btnRaz;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.TextBox txbPath;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.TextBox txbUrl;
		private System.Windows.Forms.Button btnVoir;
		private System.Windows.Forms.Panel panel2;
		private System.Windows.Forms.ListBox lstResult;
		private System.Windows.Forms.StatusBar sb;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Form1));
			this.btnDownload = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.ckbOnPage = new System.Windows.Forms.CheckBox();
			this.ckbLinked = new System.Windows.Forms.CheckBox();
			this.btnRaz = new System.Windows.Forms.Button();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.button1 = new System.Windows.Forms.Button();
			this.txbPath = new System.Windows.Forms.TextBox();
			this.panel1 = new System.Windows.Forms.Panel();
			this.btnVoir = new System.Windows.Forms.Button();
			this.txbUrl = new System.Windows.Forms.TextBox();
			this.panel2 = new System.Windows.Forms.Panel();
			this.lstResult = new System.Windows.Forms.ListBox();
			this.sb = new System.Windows.Forms.StatusBar();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			this.panel1.SuspendLayout();
			this.panel2.SuspendLayout();
			this.SuspendLayout();
			// 
			// btnDownload
			// 
			this.btnDownload.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.btnDownload.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnDownload.ForeColor = System.Drawing.Color.IndianRed;
			this.btnDownload.Location = new System.Drawing.Point(424, 32);
			this.btnDownload.Name = "btnDownload";
			this.btnDownload.Size = new System.Drawing.Size(96, 48);
			this.btnDownload.TabIndex = 1;
			this.btnDownload.Text = "Download pics";
			this.btnDownload.Click += new System.EventHandler(this.btnDownload_Click);
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.ckbOnPage,
																					this.ckbLinked});
			this.groupBox1.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.groupBox1.Location = new System.Drawing.Point(8, 24);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(408, 40);
			this.groupBox1.TabIndex = 3;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Download images who are ...";
			// 
			// ckbOnPage
			// 
			this.ckbOnPage.BackColor = System.Drawing.Color.Transparent;
			this.ckbOnPage.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.ckbOnPage.Location = new System.Drawing.Point(8, 16);
			this.ckbOnPage.Name = "ckbOnPage";
			this.ckbOnPage.Size = new System.Drawing.Size(184, 24);
			this.ckbOnPage.TabIndex = 1;
			this.ckbOnPage.Text = "On page (<img ...>)";
			// 
			// ckbLinked
			// 
			this.ckbLinked.BackColor = System.Drawing.Color.Transparent;
			this.ckbLinked.Checked = true;
			this.ckbLinked.CheckState = System.Windows.Forms.CheckState.Checked;
			this.ckbLinked.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.ckbLinked.Location = new System.Drawing.Point(224, 16);
			this.ckbLinked.Name = "ckbLinked";
			this.ckbLinked.Size = new System.Drawing.Size(176, 24);
			this.ckbLinked.TabIndex = 0;
			this.ckbLinked.Text = "Linked (<a href=\"...jpg\">)";
			this.ckbLinked.CheckedChanged += new System.EventHandler(this.checkBox1_CheckedChanged);
			// 
			// btnRaz
			// 
			this.btnRaz.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.btnRaz.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnRaz.ForeColor = System.Drawing.Color.CadetBlue;
			this.btnRaz.Location = new System.Drawing.Point(424, 88);
			this.btnRaz.Name = "btnRaz";
			this.btnRaz.Size = new System.Drawing.Size(96, 24);
			this.btnRaz.TabIndex = 4;
			this.btnRaz.Text = "RAZ";
			this.btnRaz.Click += new System.EventHandler(this.btnRaz_Click);
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.AddRange(new System.Windows.Forms.Control[] {
																					this.button1,
																					this.txbPath});
			this.groupBox2.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.groupBox2.Location = new System.Drawing.Point(8, 72);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(408, 40);
			this.groupBox2.TabIndex = 7;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Download location";
			// 
			// button1
			// 
			this.button1.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.button1.Location = new System.Drawing.Point(376, 16);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(24, 16);
			this.button1.TabIndex = 1;
			this.button1.Text = "...";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// txbPath
			// 
			this.txbPath.Location = new System.Drawing.Point(8, 16);
			this.txbPath.Name = "txbPath";
			this.txbPath.Size = new System.Drawing.Size(360, 20);
			this.txbPath.TabIndex = 0;
			this.txbPath.Text = "";
			// 
			// panel1
			// 
			this.panel1.Controls.AddRange(new System.Windows.Forms.Control[] {
																				 this.btnVoir,
																				 this.txbUrl});
			this.panel1.Dock = System.Windows.Forms.DockStyle.Top;
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(528, 24);
			this.panel1.TabIndex = 8;
			// 
			// btnVoir
			// 
			this.btnVoir.Anchor = (System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right);
			this.btnVoir.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
			this.btnVoir.Location = new System.Drawing.Point(432, 2);
			this.btnVoir.Name = "btnVoir";
			this.btnVoir.Size = new System.Drawing.Size(88, 20);
			this.btnVoir.TabIndex = 2;
			this.btnVoir.Text = "Voir";
			this.btnVoir.Click += new System.EventHandler(this.btnVoir_Click);
			// 
			// txbUrl
			// 
			this.txbUrl.AllowDrop = true;
			this.txbUrl.Anchor = (((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right);
			this.txbUrl.Name = "txbUrl";
			this.txbUrl.Size = new System.Drawing.Size(424, 20);
			this.txbUrl.TabIndex = 1;
			this.txbUrl.Text = "http://mournblade.ath.cx/";
			// 
			// panel2
			// 
			this.panel2.Controls.AddRange(new System.Windows.Forms.Control[] {
																				 this.sb,
																				 this.lstResult});
			this.panel2.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.panel2.Location = new System.Drawing.Point(0, 117);
			this.panel2.Name = "panel2";
			this.panel2.Size = new System.Drawing.Size(528, 208);
			this.panel2.TabIndex = 9;
			// 
			// lstResult
			// 
			this.lstResult.Dock = System.Windows.Forms.DockStyle.Fill;
			this.lstResult.Name = "lstResult";
			this.lstResult.Size = new System.Drawing.Size(528, 199);
			this.lstResult.TabIndex = 2;
			// 
			// sb
			// 
			this.sb.Location = new System.Drawing.Point(0, 192);
			this.sb.Name = "sb";
			this.sb.Size = new System.Drawing.Size(528, 16);
			this.sb.TabIndex = 3;
			this.sb.Text = "Bonne journe";
			// 
			// Form1
			// 
			this.AcceptButton = this.btnDownload;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(528, 325);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.panel2,
																		  this.panel1,
																		  this.groupBox2,
																		  this.btnRaz,
																		  this.groupBox1,
																		  this.btnDownload});
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.MaximizeBox = false;
			this.MinimumSize = new System.Drawing.Size(536, 352);
			this.Name = "Form1";
			this.Text = "Web Pics Downloader + IE :: by Alain VIZZINI (alainvizzini@altern.org)";
			this.Load += new System.EventHandler(this.Form1_Load);
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			this.panel1.ResumeLayout(false);
			this.panel2.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

		/// <summary>
		/// Telecharge le document d'url <c>imgUrl</c>. Le fichier sera sauv dans <c>pathToSave</c>.
		/// </summary>
		/// <param name="imgUrl">chemin du fichier</param>
		/// <param name="pathToSave">Chemin o sauver le fichier (/-terminated)</param>
		private void DownloadDocument (string imgUrl, string pathToSave)
		{

			//le nom de fichier "toto.jpg"-like
			String imgFileName = (imgUrl.LastIndexOf("/") < 0 ? imgUrl : imgUrl.Substring(imgUrl.LastIndexOf("/")));

			HttpWebResponse imgWR = null;
			HttpWebRequest imgHWR = (HttpWebRequest)WebRequest.Create (imgUrl);

			//on ment sur son identit (pas necessaire)
			imgHWR.UserAgent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; DVD Owner; .NET CLR 1.0.3705)";
			//ULTRA IMPORTANT ! On fait croire qu'on vient de la page contenant les liens !!!
			imgHWR.Referer = txbUrl.Text;

			try
			{
				imgWR = (HttpWebResponse)imgHWR.GetResponse();
				Stream stream = imgWR.GetResponseStream();

				using (FileStream fs = new FileStream (pathToSave + imgFileName, FileMode.Create))
				{
					byte[] buf = new byte[1024];
					int lu = 0;

					while ((lu = stream.Read (buf,0, buf.Length)) != 0)
					{
						fs.Write (buf, 0, lu);
					}
				}

				lstResult.Items.Add(imgFileName + " : OK (" + imgUrl + ")");
				sb.Text = "Ok : " + imgUrl;
			}
			catch (WebException wex)
			{
				lstResult.Items.Add(imgFileName + " : EXCEPTION "+ wex.Message);
				sb.Text = "Err : " + imgUrl;
			}
			finally
			{
				if (imgWR != null)
					imgWR.Close();
			}
		
		}

		private void GoForDownload(object bidon) { GoForDownload(); }
		private void GoForDownload()
		{
			string thePath = txbPath.Text;
			string theUrl = txbUrl.Text;

			//verif si le rpertoire de tlchargement est accessible
			if (!Directory.Exists(thePath))
				Directory.CreateDirectory (thePath);

			string pathToSave = thePath + (thePath[thePath.Length -1] == '\\' ? "" : "\\");

			HttpWebResponse wr = null;
			try
			{
				lstResult.Items.Add("--- Starting task : " +theUrl+ "---");
				sb.Text = "Starting " + theUrl;

				lstResult.BeginUpdate();

				HttpWebRequest hwr = (HttpWebRequest)WebRequest.Create (theUrl);
				wr = (HttpWebResponse)hwr.GetResponse();
			
				using (StreamReader sr = new StreamReader (wr.GetResponseStream()))
				{
					String line;
					while ((line = sr.ReadLine()) != null)
					{
						//!!! images en liens
						if (ckbLinked.Checked)
						{
							//pour chaque occurence de <a href ...>
							foreach (Match m in rAHref.Matches(line))	
							{
								//si image
								string imgURL = rAHref.Match (m.Value).Result ("${destUrl}");

								if (imgURL != null && (imgURL.ToLower().EndsWith(".jpg") || imgURL.ToLower().EndsWith(".gif") ||imgURL.ToLower().EndsWith(".png")))
								{
									String imgUrlComplex = theUrl.Substring(0, theUrl.LastIndexOf("/")+1) + imgURL;
									DownloadDocument(imgUrlComplex, pathToSave);									
								}
							}							
						}

						//!!! images de la page
						if (ckbOnPage.Checked)
						{
							//pour chaque ligne
							if(rImg.IsMatch (line))
							{
								//pour chaque occurence de <img ...>
								foreach (Match m in rImg.Matches(line))	
								{
									//contient un attibut 'src=""'
									if (rSrcAttr.IsMatch (m.Value))
									{
										String imgURL = rSrcAttr.Match (m.Value).Result ("${imgUrl}");
										String imgUrlComplex = theUrl.Substring(0, theUrl.LastIndexOf("/")+1) + imgURL;

										DownloadDocument(imgUrlComplex, pathToSave);
									}
								}
							}						
						}
					}

					lstResult.Items.Add("---...---");
					sb.Text = theUrl+ " : DONE.";
				}
			}
			finally
			{
				if (wr != null)
					wr.Close();

				lstResult.EndUpdate();
			}
		
		}

		private void btnDownload_Click(object sender, System.EventArgs e)
		{
			//the SOFT way
			if (! ThreadPool.QueueUserWorkItem (new WaitCallback (GoForDownload)))
			{
				//the HARD way
				System.Windows.Forms.MessageBox.Show( 
					this, 
					"Processus lourd utilis.",
					"Info",
					System.Windows.Forms.MessageBoxButtons.OK,
					System.Windows.Forms.MessageBoxIcon.Information
					);

				Thread thrUpdater = new Thread (new ThreadStart(GoForDownload));
				thrUpdater.Start();
			}
		}

		private void checkBox1_CheckedChanged(object sender, System.EventArgs e)
		{
		
		}

		private void btnRaz_Click(object sender, System.EventArgs e)
		{
			txbUrl.Text = "http://mournblade.ath.cx/";
			txbPath.Text = Application.StartupPath;
			lstResult.Items.Clear();
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			FolderDialog fd = new FolderDialog();
			if (fd.DisplayDialog ("Choisissez un rpertoire") == DialogResult.OK)
				txbPath.Text = fd.Path;
		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
			txbPath.Text = Application.StartupPath;
		}

		private void txbUrl_DragDrop(object sender, System.Windows.Forms.DragEventArgs e)
		{
			txbUrl.Text = e.Data.ToString();
		}

		private void btnVoir_Click(object sender, System.EventArgs e)
		{
			if (ieView != null)
				ieView.BringToFront();


			if (txbUrl.Text != null && !txbUrl.Text.Equals(String.Empty))
				ieView = new frmIEView(txbUrl.Text);
			else
				ieView = new frmIEView();

			ieView.Closed += new EventHandler (OnieViewClosed);

			ieView.Show();
		}

		private void OnieViewClosed(Object sender, EventArgs e){
			ieView = null;
		}
	}
}
